# NewsReader

This Xcode project is a starting point for an app displaying news articles.
It contains a mocked API (NewsAPI.swift) with 2 endpoints:
- `newsStream` simulates live updates of news article overviews
- `getNewsDetail` returns asynchronously a news article detail or an error

Please create an app which implements the following user stories:

- As a user I want to see a list of article overviews that updates when new articles are received.
- As a user I want to see the title, shortText, and tags in the list of article overviews.
- As a user I want to select an article and see more details.
- As a user I want to be informed if loading of article details is in progress or failed.
- As a user I want to retry loading of article details when initial loading has failed.
- As a developer I want to cache the article details by ID with an expiry time of 5 minutes. In the app, I first want to retrieve the article details from cache, only if that fails I want to fetch the article details from the NewsAPI.

Choose an approach and an app architecture you think is most suitable for building a mid-sized app which has to be maintained over a long time by a small team, and which will get constantly extended. 
Make sure to add proper and sufficient unit testing. (One example of each test for a view model, a use case, and the caching component is enough)

Feel free to change anything in the current setup/code of the project,
