//
//  NewsOverviewStoreTests.swift
//  NewsStores
//
//  Created by Michael Bernat on 03.12.2025.
//

import Testing
import Observation
@testable import NewsStores

@MainActor
struct NewsOverviewStoreTests {

    let newsOverviewProvider = NewsOverviewProviderMock()
    
    @Test("Fetch task exists after start")
    func fetchTaskExists() async {
        let store = NewsOverviewStore(provider: newsOverviewProvider)
        #expect(store.fetchTask == nil)
        store.startUpdates()
        #expect(store.fetchTask != nil)
    }
    
    @Test("Fetch task is nil after stop")
    func fetchTaskIsNil() async {
        let store = NewsOverviewStore(provider: newsOverviewProvider)
        store.startUpdates()
        store.stopUpdates()
        #expect(store.fetchTask == nil)
    }
    
    @available(iOS 26, *)
    @Test("Fetch runs and NewsOverviews are observed")
    func newsOverviewsObservations() async {
        // this test should be improved by failure on timeout
        let store = NewsOverviewStore(provider: newsOverviewProvider)
        
        let newsOverviewsSequence = Observations { store.newsOverviews }
        var newsOverviewsCounts: [Int] = []
        let task = Task {
            for await newsOverviews in newsOverviewsSequence {
                guard let newsOverviews else { continue }
                newsOverviewsCounts.append(newsOverviews.count)
                if newsOverviewsCounts.count == 2 { break }
            }
        }
        
        #expect(store.newsOverviews == nil)
        store.startUpdates()
        await task.value
        #expect(newsOverviewsCounts == [5, 6])
        
        store.stopUpdates()
    }

}
