//
//  NewsOverviewProviderMock.swift
//  NewsStores
//
//  Created by Michael Bernat on 03.12.2025.
//

import NewsStores
import NewsAPI
import NewsAPIModels

final class NewsOverviewProviderMock: NewsOverviewProviding {
    
    func newsStream() -> AsyncStream<[NewsAPIModels.NewsOverview]> {
        NewsAPI.newsStream()
    }
    
    func transform(_ value: NewsAPIModels.NewsOverview) -> NewsStores.NewsOverview {
        NewsStores.NewsOverview(from: value)
    }
    
    init() {
        
    }
}
