//
//  NewsDetailAlwaysFailingMock.swift
//  NewsStores
//
//  Created by Michael Bernat on 04.12.2025.
//

import NewsStores
import NewsAPI
import NewsAPIModels

final class NewsDetailAlwaysFailingMock: NewsDetailProviding {
    
    func getNewsDetail(id: String) async throws(NewsAPIModels.NewsError) -> NewsAPIModels.NewsDetail {
        try await NewsAPI.getNewsDetail(id, canRandomFail: true, alwaysFails: true)
    }
    
    func transform(_ value: NewsAPIModels.NewsDetail) -> NewsStores.NewsDetail {
        NewsStores.NewsDetail(from: value)
    }
    
    func transform(_ error: NewsAPIModels.NewsError) -> NewsStores.NewsError {
        NewsStores.NewsError(from: error)
    }
    
    init() {
        
    }
}
