//
//  NewsDetailProviding.swift
//  NewsStores
//
//  Created by Michael Bernat on 02.12.2025.
//

public protocol NewsDetailProviding: Sendable {
    
    associatedtype APIDetail
    associatedtype APIError: Error
    
    func getNewsDetail(id: String) async throws(APIError) -> APIDetail
    
    func transform(_: APIDetail) -> NewsDetail
    
    func transform(_: APIError) -> NewsError
}
