//
//  NewsTag.swift
//  NewsStores
//
//  Created by Michael Bernat on 05.12.2025.
//

import NewsAPIModels

public enum NewsTag: Int, Sendable, Identifiable, CaseIterable {
    
    case technology
    case economy
    case science
    case sports
    case healthcare
    case climate
    
    public var id: Int { rawValue }
    
    public init(from newsTag: NewsAPIModels.NewsTag) {
        switch newsTag {
        case .climate: self = .climate
        case .economy: self = .economy
        case .healthcare: self = .healthcare
        case .science: self = .science
        case .sports: self = .sports
        case .technology: self = .technology
        }
    }
}
