//
//  NewsOverview.swift
//  NewsStores
//
//  Created by Michael Bernat on 05.12.2025.
//

import Foundation
import NewsAPIModels

public struct NewsOverview: Sendable, Identifiable {
    public let id: String
    public let date: Date
    public let tags: [NewsTag]
    public let title: String
    public let shortText: String
    
    public init(id: String, date: Date, tags: [NewsTag], title: String, shortText: String) {
        self.id = id
        self.date = date
        self.tags = tags
        self.title = title
        self.shortText = shortText
    }
    
    public init(from newsOverview: NewsAPIModels.NewsOverview) {
        id = newsOverview.id
        date = newsOverview.date
        tags = newsOverview.tags.map { NewsTag(from: $0) }
        title = newsOverview.title
        shortText = newsOverview.shortText
    }
}
