//
//  NewsDetail.swift
//  NewsStores
//
//  Created by Michael Bernat on 05.12.2025.
//

import Foundation
import NewsAPIModels

public struct NewsDetail: Sendable, Identifiable {
    public let id: String
    public let tags: [NewsTag]
    public let date: Date
    public let title: String
    public let perex: String
    public let body: String
    
    public init(id: String, tags: [NewsTag], date: Date, title: String, perex: String, body: String) {
        self.id = id
        self.tags = tags
        self.date = date
        self.title = title
        self.perex = perex
        self.body = body
    }
    
    public init(from newsDetail: NewsAPIModels.NewsDetail) {
        self.id = newsDetail.id
        self.tags = newsDetail.tags.map { NewsTag(from: $0) }
        self.date = newsDetail.date
        self.title = newsDetail.title
        self.perex = newsDetail.perex
        self.body = newsDetail.body
    }
}
