// swift-tools-version: 6.2
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
    name: "NewsStores",
    platforms: [.iOS(.v17)],
    products: [
        // Products define the executables and libraries a package produces, and make them visible to other packages.
        .library(
            name: "NewsStores",
            targets: ["NewsStores"]
        ),
    ],
    dependencies: [
        // Dependencies declare other packages that this package depends on.
        .package(name: "NewsAPI", path: "../NewsAPI")
    ],
    targets: [
        // Targets are the basic building blocks of a package. A target can define a module or a test suite.
        // Targets can depend on other targets in this package, and on products in packages this package depends on.
        .target(
            name: "NewsStores",
            dependencies: [
                .product(name: "NewsAPI", package: "NewsAPI"),
                .product(name: "NewsAPIModels", package: "NewsAPI")
            ]
        ),
        .testTarget(
            name: "NewsStoresTests",
            dependencies: [
                "NewsStores",
                .product(name: "NewsAPI", package: "NewsAPI")
            ]
        ),
    ],
    swiftLanguageModes: [.v6]
)
