//
//  TagsScrollView.swift
//  NewsReader
//
//  Created by Michael Bernat on 06.12.2025.
//

import SwiftUI
import NewsStores

struct TagsScrollView: View {
    
    /// Tags
    let tags: [NewsTag]
    
    var body: some View {
        ScrollView(.horizontal) {
            HStack(spacing: 8) {
                ForEach(tags) { tag in
                    Text(tag.localizedText)
                        .padding(.horizontal, 8)
                        .padding(.vertical, 4)
                        .background {
                            RoundedRectangle(cornerRadius: 8)
                                .foregroundStyle(tag.background)
                        }
                }
            }
        }
        .scrollIndicators(.hidden)
    }
}

#Preview {
    TagsScrollView(
        tags: [.climate, .healthcare, .sports, .technology]
    )
}
