//
//  NewsOverviewListView.swift
//  NewsReader
//
//  Created by Michael Bernat on 05.12.2025.
//

import SwiftUI
import NewsStores

struct NewsOverviewListView: View {
    
    /// Navigation bar title
    let title: String
    
    /// News Overview Store
    @Environment(NewsOverviewStore.self) private var newsOverviewStore
    
    var body: some View {
        Group {
            if let newsOverviews = newsOverviewStore.newsOverviews {
                List(newsOverviews) { newsOverview in
                    NavigationLink(value: NavigatorRoute.newsDetail(id: newsOverview.id)) {
                        NewsOverviewCell(
                            title: newsOverview.title,
                            shortText: newsOverview.shortText,
                            tags: newsOverview.tags
                        )
                    }
                }
                .onDisappear {
                    // intentionally not stopping
                    // newsOverviewStore.stopUpdates()
                }
            } else {
                ProgressView()
            }
        }
        .navigationTitle(title)
        .onAppear {
            newsOverviewStore.startUpdates()
        }
    }
}
