//
//  NewsOverviewCell.swift
//  NewsReader
//
//  Created by Michael Bernat on 05.12.2025.
//

import SwiftUI
import NewsStores

struct NewsOverviewCell: View {
    
    /// Title
    let title: String
    
    /// Short text
    let shortText: String
    
    /// Tags
    let tags: [NewsTag]
    
    var body: some View {
        VStack(alignment: .leading, spacing: 8) {
            // title
            Text(title)
                .font(.headline)
            // short text
            Text(shortText)
            // tags
            TagsScrollView(tags: tags)
        }
    }
}

#Preview {
    NewsOverviewCell(
        title: "Preview title",
        shortText: "With short text",
        tags: [.healthcare, .economy, .science]
    )
}
