//
//  NewsDetailView.swift
//  NewsReader
//
//  Created by Michael Bernat on 06.12.2025.
//

import SwiftUI
import NewsStores

struct NewsDetailView: View {
    
    /// News ID
    let id: String
    
    /// News Details Store
    @Environment(NewsDetailsStore.self) private var newsDetailsStore
    
    var body: some View {
        Group {
            switch newsDetailsStore.newsDetailStatus(for: id) {
            case .newsDetail(let newsDetail):
                NewsDetailScrollView(
                    title: newsDetail.title,
                    perex: newsDetail.perex,
                    fullBody: newsDetail.body,
                    tags: newsDetail.tags
                )
                .safeAreaPadding()
                .navigationTitle(Text(newsDetail.date, style: .date))
            case .inProgress, nil:
                ProgressView()
            case .error:
                ContentUnavailableView {
                    Label("newsDetail.error.title", systemImage: SystemImage.exclamationmarkTriangle.rawValue)
                } description: {
                    Text("newsDetail.error.message")
                } actions: {
                    Button("newsDetail.error.retry") { newsDetailsStore.startFetchIfNeeded(for: id) }
                        .buttonStyle(.borderedProminent)
                }
            }
        }
        .onAppear {
            newsDetailsStore.startFetchIfNeeded(for: id)
        }
        .onDisappear {
            // can be purged when no other view displays any (already expired) news detail
            newsDetailsStore.purgeExpiredNewsDetails()
        }
    }
}
