//
//  NewsDetailScrollView.swift
//  NewsReader
//
//  Created by Michael Bernat on 06.12.2025.
//

import SwiftUI
import NewsStores

struct NewsDetailScrollView: View {
    
    /// Title
    let title: String
    
    /// Perex
    let perex: String
    
    /// Body
    let fullBody: String
    
    /// Tags
    let tags: [NewsTag]
    
    var body: some View {
        ScrollView(.vertical) {
            VStack(alignment: .leading, spacing: 16) {
                // title
                Text(title)
                    .font(.title)
                // tags
                TagsScrollView(tags: tags)
                // perex
                Text(perex)
                //
                Divider()
                // body
                Text(fullBody)
            }
        }
    }
}

#Preview {
    NewsDetailScrollView(
        title: "Title",
        perex: "Perex Perex Perex Perex",
        fullBody: "Body Body Body Body Body Body Body Body Body Body Body Body Body Body Body Body",
        tags: [.climate, .healthcare, .sports]
    )
}
