//
//  ViewFactory.swift
//  NewsReader
//
//  Created by Michael Bernat on 02.12.2025.
//

import SwiftUI
import NewsStores

@MainActor
/// Factory.
final class ViewFactory: Sendable {
    
    /// Source of Truth
    let sourceOfTruth: SourceOfTruth
    
    /// Makes view
    /// - Parameter navigatorRoute: Route
    /// - Returns: View
    @ViewBuilder
    func makeView(for navigatorRoute: NavigatorRoute) -> some View {
        switch navigatorRoute {
        case let .newsOverviews(title): makeNewsOverviewView(title: title)
        case let .newsDetail(id): makeNewsDetailView(id: id)
        }
    }
    
    /// Makes NewsOverviewListView
    /// - Parameter title: Title
    /// - Returns: View
    func makeNewsOverviewView(title: String) -> some View {
        NewsOverviewListView(title: title)
            .environment(sourceOfTruth.newsOverviewStore)
    }
    
    /// Makes NewsDetailView
    /// - Parameter id: News ID
    /// - Returns: View
    func makeNewsDetailView(id: String) -> some View {
        NewsDetailView(id: id)
            .environment(sourceOfTruth.newsDetailsStore)
    }
    
    /// Initializer
    /// - Parameter sourceOfTruth: Truth
    init(sourceOfTruth: SourceOfTruth) {
        self.sourceOfTruth = sourceOfTruth
    }
}
