//
//  NewsTag+UI.swift
//  NewsReader
//
//  Created by Michael Bernat on 05.12.2025.
//

import SwiftUI
import NewsStores

extension NewsTag {
    
    var background: some ShapeStyle {
        switch self {
        case .technology: Color.blue.opacity(0.5)
        case .economy: Color.orange.opacity(0.5)
        case .science: Color.yellow.opacity(0.5)
        case .sports: Color.red.opacity(0.5)
        case .healthcare: Color.indigo.opacity(0.5)
        case .climate: Color.green.opacity(0.5)
        }
    }
 
    var localizedText: String {
        switch self {
        case .technology: String(localized: "newsTag.technology")
        case .economy: String(localized: "newsTag.economy")
        case .science: String(localized: "newsTag.science")
        case .sports: String(localized: "newsTag.sports")
        case .healthcare: String(localized: "newsTag.healthcare")
        case .climate: String(localized: "newsTag.climate")
        }
    }
    
}
