//
//  SourceOfTruth.swift
//  NewsReader
//
//  Created by Michael Bernat on 05.12.2025.
//

import NewsStores
import Navigator

typealias NewsOverviewStore = NewsStores.NewsOverviewStore<NewsProvider>
typealias NewsDetailsStore = NewsStores.NewsDetailsStore<NewsProvider>

@MainActor
/// Just a stores container.
final class SourceOfTruth: Sendable {
    
    /// Store
    let newsOverviewStore: NewsOverviewStore
    
    /// Store
    let newsDetailsStore: NewsDetailsStore
    
    /// Store
    let navigatorStore: NavigatorStore<NavigatorRoute>
    
    /// Initializer
    init(
        newsOverviewStore: NewsOverviewStore,
        newsDetailsStore: NewsDetailsStore,
        navigatorStore: NavigatorStore<NavigatorRoute>
    ) {
        self.newsOverviewStore = newsOverviewStore
        self.newsDetailsStore = newsDetailsStore
        self.navigatorStore = navigatorStore
    }
}
