//
//  NewsReaderApp.swift
//  NewsReader
//
//  Created by woko on 03.11.2025.
//

import SwiftUI
import NewsStores
import Navigator

@main
struct NewsReaderApp: App {
    
    /// Single source of truth
    @State private var sourceOfTruth: SourceOfTruth
    
    /// View factory
    @State private var viewFactory: ViewFactory
    
    var body: some Scene {
        WindowGroup {
            Navigator(
                navigatorStore: sourceOfTruth.navigatorStore,
                viewFactory: viewFactory.makeView(for: )
            ) {
                // root view
                viewFactory.makeNewsOverviewView(title: String(localized: "newsOverviews.title"))
            }
        }
    }
    
    /// Initializer
    init() {
        let newsAPI = NewsProvider.shared
        let newsOverviewStore = NewsOverviewStore(provider: newsAPI)
        let newsDetailsStore = NewsDetailsStore(provider: newsAPI)
        let navigatorStore = NavigatorStore<NavigatorRoute>()
        let sourceOfTruth = SourceOfTruth(
            newsOverviewStore: newsOverviewStore,
            newsDetailsStore: newsDetailsStore,
            navigatorStore: navigatorStore
        )
        self.sourceOfTruth = sourceOfTruth
        viewFactory = ViewFactory(sourceOfTruth: sourceOfTruth)
    }
}
