//
//  NewsProvider.swift
//  NewsReader
//
//  Created by Michael Bernat on 05.12.2025.
//

import NewsAPI
import NewsAPIModels
import NewsStores

final class NewsProvider: Sendable, NewsOverviewProviding, NewsDetailProviding {
    
    static let shared = NewsProvider()
    
    func newsStream() -> AsyncStream<[NewsAPIModels.NewsOverview]> {
        NewsAPI.newsStream()
    }
    
    func getNewsDetail(id: String) async throws(NewsAPIModels.NewsError) -> NewsAPIModels.NewsDetail {
        try await NewsAPI.getNewsDetail(id)    
    }
    
    func transform(_ value: NewsAPIModels.NewsOverview) -> NewsStores.NewsOverview {
        NewsStores.NewsOverview(from: value)
    }
    
    func transform(_ value: NewsAPIModels.NewsDetail) -> NewsStores.NewsDetail {
        NewsStores.NewsDetail(from: value)
    }
    
    func transform(_ error: NewsAPIModels.NewsError) -> NewsStores.NewsError {
        NewsStores.NewsError(from: error)
    }
}
