//
//  Models.swift
//  NewsAPI
//
//  Created by Michael Bernat on 04.12.2025.
//

import Foundation

public struct NewsOverview: Sendable, Decodable {
    public let id: String
    public let date: Date
    public let tags: [NewsTag]
    public let title: String
    public let shortText: String
    
    public init(id: String, date: Date, tags: [NewsTag], title: String, shortText: String) {
        self.id = id
        self.date = date
        self.tags = tags
        self.title = title
        self.shortText = shortText
    }
}

public struct NewsDetail: Sendable, Decodable {
    public let id: String
    public let tags: [NewsTag]
    public let date: Date
    public let title: String
    public let perex: String
    public let body: String
    
    public init(id: String, tags: [NewsTag], date: Date, title: String, perex: String, body: String) {
        self.id = id
        self.tags = tags
        self.date = date
        self.title = title
        self.perex = perex
        self.body = body
    }
}

public enum NewsTag: String, Sendable, Decodable, CaseIterable {
    case technology
    case economy
    case science
    case sports
    case healthcare
    case climate
}

public enum NewsError: Error {
    case randomError
}
