//
//  NavigatorStore.swift
//  Navigator
//
//  Created by Michael Bernat on 05.12.2025.
//

import SwiftUI

@MainActor
@Observable
/// Navigator store
public final class NavigatorStore<V: Codable & Hashable>: Sendable {
    
    /// Path
    var navigationPath = NavigationPath()
    
    /// Initializer
    public init() {
        
    }
    
    /// Pushes new item on to of navigation stack
    /// - Parameter value: Value
    public func push(_ value: V) {
        navigationPath.append(value)
    }
}
