//
//  Navigator.swift
//  NewsReader
//
//  Created by Michael Bernat on 05.12.2025.
//

import SwiftUI

public struct Navigator<RootView: View, ViewFactoryView: View, NavPathValue: Codable & Hashable>: View {
    
    /// Makes view for NavPathValue
    let viewFactory: (NavPathValue) -> ViewFactoryView
    
    /// Root view
    let rootView: () -> RootView
    
    /// Navigation path inside
    @Bindable var navigatorStore: NavigatorStore<NavPathValue>
    
    public var body: some View {
        NavigationStack(path: $navigatorStore.navigationPath) {
            rootView()
                .navigationDestination(for: NavPathValue.self) {
                    viewFactory($0)
                }
        }
    }
    
    /// Initializer
    /// - Parameters:
    ///   - navigatorStore: Navigator Store
    ///   - viewFactory: Factory
    ///   - rootView: Root
    public init(
        navigatorStore: NavigatorStore<NavPathValue>,
        @ViewBuilder viewFactory: @escaping (NavPathValue) -> ViewFactoryView,
        @ViewBuilder rootView: @escaping () -> RootView
    ) {
        self.navigatorStore = navigatorStore
        self.viewFactory = viewFactory
        self.rootView = rootView
    }
}
